% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{ipf}
\alias{ipf}
\title{Multidimensional IPF}
\usage{
ipf(seed, indices, marginals)
}
\arguments{
\item{seed}{an n-dimensional array of seed values}

\item{indices}{a List of 1-d arrays specifying the dimension indices of each marginal as they apply to the seed values}

\item{marginals}{a List of arrays containing marginal data. The sum of elements in each array must be identical}
}
\value{
an object containing:
\itemize{
  \item{a flag indicating if the solution converged}
  \item{the population matrix}
  \item{the total population}
  \item{the number of iterations required}
  \item{the maximum error between the generated population and the marginals}
}
}
\description{
C++ multidimensional IPF implementation
}
\examples{
ageByGender = array(c(1,2,5,3,4,3,4,5,1,2), dim=c(5,2))
ageByEthnicity = array(c(4,6,5,6,4,5), dim=c(3,2))
seed = array(rep(1,30), dim=c(5,2,3))
result = ipf(seed, list(c(1,2), c(3,2)), list(ageByGender, ageByEthnicity))
}
