% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humidity.R
\name{SVP}
\alias{SVP}
\title{calculate saturation vapor pressure}
\usage{
SVP(t, isK = TRUE, formula = c("Clausius-Clapeyron", "Murray"))
}
\arguments{
\item{t}{temperature in Kelvin (K) or in degree Celsius (°C)}

\item{isK}{logical indicator whether temperature is in Kelvin (K). The default value is TRUE.}

\item{formula}{the formula is used for calculating saturation vapor pressure. By default the Clausius-Clapeyron equation is used.}
}
\value{
numeric saturation vapor pressure in hectopascal (hPa) or millibar (mb)
}
\description{
calculate saturation vapor pressure \eqn{E_s} at temperature \eqn{t}, using the Clausius-Clapeyron equation or the Murray equation.
}
\examples{
SVP(273.15)
}
\seealso{
\code{\link{SVP.ClaCla}}, \code{\link{SVP.Murray}}.
}
\author{
Jun Cai (\email{cai-j12@mails.tsinghua.edu.cn}), PhD candidate from
Department of Earth System Science, Tsinghua University
}
