% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_colr.R
\name{drop_colr}
\alias{drop_colr}
\alias{drop_grep}
\title{Drop columns whose names match a pattern}
\usage{
drop_colr(DT, pattern, ..., checkDT = TRUE)
}
\arguments{
\item{DT}{A \code{data.table}.}

\item{pattern}{A regular expression as in \code{grepl}.}

\item{...}{Arguments passed to \code{grepl}.}

\item{checkDT}{If \code{TRUE} (the default), will error if \code{DT} is not a \code{data.table}.}
}
\description{
\code{drop_colr} present since \code{hutils 1.0.0}.

\code{drop_grep} is identical but only present since \code{hutils 1.2.0}.
}
\examples{
library(data.table)
dt <- data.table(x1 = 1, x2 = 2, y = 3)
drop_grep(dt, "x")


}
