% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Switch.R
\name{Switch}
\alias{Switch}
\title{Vectorized switch}
\usage{
Switch(Expr, ..., DEFAULT, IF_NA = NULL, MUST_MATCH = FALSE)
}
\arguments{
\item{Expr}{A character vector.}

\item{...}{As in \code{\link[base]{switch}}, a list of named alternatives.
Unlike \code{switch}, unnamed vectors are taken to match \code{""}. Likewise, 
\code{NA} values in \code{Expr} must be assigned via \code{IF_NA}.}

\item{DEFAULT}{A mandatory default value should any name of \code{...} be left unmatched.}

\item{IF_NA}{Optional value to replace missing (\code{NA_character_}) values in \code{Expr}.}

\item{MUST_MATCH}{(logical, default: \code{FALSE}) Must every value in \code{Expr} be matched by a conversion in \code{...}? 
If \code{TRUE} any output equal to the value of \code{DEFAULT} is an error.}
}
\value{
For every element of \code{...} whose name matches an element of \code{Expr}, 
that element's value.
}
\description{
Present since \code{hutils 1.2.0}. Vectorized version of \code{switch}. Used to avoid or make clearer the result of 
\code{if_else(Expr == , ..1, if_else(Expr == , ..2, ...))}
}
\examples{
Switch(c("a", "b", "c", "a"),
       "a" = 1, 
       "b" = 2, 
       "c" = 3, 
       "4" = 4, 
       DEFAULT = 0)

}
