% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{text_color}
\alias{text_color}
\alias{text_color<-}
\alias{set_text_color}
\alias{text_color.huxtable}
\alias{text_color<-.huxtable}
\title{Text color}
\usage{
text_color(ht)
text_color(ht) <- value
set_text_color(ht, row, col, value, byrow = FALSE)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A character vector or matrix of valid R color names. Set to \code{NA} to reset to the default.}

\item{row}{A row specifier. See \code{\link{rowspecs}} for details.}

\item{col}{An optional column specifier.}

\item{byrow}{If \code{TRUE}, fill in values by row rather than by column.}
}
\value{
For \code{text_color}, the \code{text_color} attribute.
For \code{set_text_color}, the \code{ht} object.
}
\description{
Functions to get or set the text color property of huxtable table cells.
}
\examples{

ht <- huxtable(a = 1:3, b = 1:3)
text_color(ht) <-  'blue'
text_color(ht)


ht <- huxtable(a = 1:3, b = 3:1)
set_text_color(ht, 'blue')
set_text_color(ht, 1:2, 1, 'blue')
set_text_color(ht, 1:2, 1:2, c('blue', 'red'), byrow = TRUE)
set_text_color(ht, where(ht == 1), 'blue')
}
\seealso{
Other formatting functions: \code{\link{background_color}},
  \code{\link{bold}}, \code{\link{font_size}},
  \code{\link{font}}, \code{\link{na_string}},
  \code{\link{number_format}}
}
\concept{formatting functions}
