% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/huxtable.R
\name{as_huxtable}
\alias{as_huxtable}
\alias{as_hux}
\alias{as_huxtable.default}
\alias{is_huxtable}
\alias{is_hux}
\title{Convert objects to huxtables}
\usage{
as_huxtable(x, ...)

as_hux(x, ...)

\method{as_huxtable}{default}(x,
  add_colnames = getOption("huxtable.add_colnames", FALSE),
  add_rownames = FALSE, autoformat = getOption("huxtable.autoformat",
  TRUE), ...)

is_huxtable(x)

is_hux(x)
}
\arguments{
\item{x}{Object to convert.}

\item{...}{Arguments passed on to \code{\link[=huxtable]{huxtable()}}.}

\item{add_colnames}{If \code{TRUE}, add a first row of column names to the huxtable.}

\item{add_rownames}{If \code{TRUE}, add a first column of row names, named 'rownames', to the huxtable.}

\item{autoformat}{If \code{TRUE}, automatically format columns by type. See below.}
}
\value{
An object of class "huxtable".
}
\description{
\code{as_huxtable} or \code{as_hux} converts an object to a huxtable.
Conversion methods exist for data frames, tables, ftables, matrices and (most) vectors.
\code{is_hux[table]} tests if an object is a huxtable.
}
\examples{
dfr <- data.frame(a = 1:5, b = letters[1:5], stringsAsFactors = FALSE)
as_huxtable(dfr)
mx <- matrix(letters[1:12], 4, 3)
as_huxtable(mx)
library(stats)
tbl <- table(Wool = warpbreaks$wool, Tension = warpbreaks$tension)
as_huxtable(tbl) # adds row and column names by default
}
