% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latex.R
\name{print_latex}
\alias{print_latex}
\alias{to_latex}
\alias{to_latex.huxtable}
\title{Create LaTeX representing a huxtable}
\usage{
print_latex(ht, ...)

to_latex(ht, ...)

\method{to_latex}{huxtable}(ht, tabular_only = FALSE, ...)
}
\arguments{
\item{ht}{A huxtable.}

\item{...}{Arguments to pass to methods.}

\item{tabular_only}{Return only the LaTeX tabular, not the surrounding float.}
}
\value{
\code{to_latex} returns a string. \code{print_latex} prints the string and returns \code{NULL}.
}
\description{
Create LaTeX representing a huxtable
}
\details{
If we appear to be in a rmarkdown document with the Pandoc markdown \code{+raw_attribute} extension
available, \code{to_latex} will return LaTeX surrounded by a "raw attribute code block" (see
https://pandoc.org/MANUAL.html#extension-raw_attribute). This helps protect against pandoc
accidentally escaping the TeX code.
}
\examples{
ht <- huxtable(
        a = 1:3,
        b = letters[1:3]
      )
print_latex(ht)
}
\seealso{
Other printing functions: \code{\link{print_html}},
  \code{\link{print_md}}, \code{\link{print_rtf}},
  \code{\link{print_screen}}
}
\concept{printing functions}
