% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties.R
\name{font}
\alias{font}
\alias{font<-}
\alias{set_font}
\alias{map_font}
\title{Font}
\usage{
font(ht)
font(ht) <- value
set_font(ht, row, col, value, byrow = FALSE)
map_font(ht, row, col, fn)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A character vector of font names.

Set to \code{NA} to reset to the default, which is \code{NA}.}

\item{row}{A row specifier. See \link{rowspecs} for details.}

\item{col}{An optional column specifier.}

\item{fn}{A mapping function. See \link{mapping-functions} for details.}

\item{byrow}{Deprecated. Use \code{\link[=by_cols]{by_cols()}} instead.}
}
\value{
For \code{font}, the \code{font} property.
For \code{set_font} and \code{map_font}, the modified huxtable.
}
\description{
Functions to get or set the \emph{font} property of huxtable cells.
}
\details{
LaTeX and HTML use different font names. If you want to use the same font
names across document formats, set \code{options("huxtable.latex_use_fontspec")}
to \code{TRUE}. See \link{huxtable-options}.
}
\examples{

font(jams) <-  "times"
font(jams)


jams2 <- set_font(jams,
      "times")
font(jams2)

jams3 <- set_font(jams,
      2:3, 1, "times")
font(jams3)

jams4 <- map_font(jams,
      by_rows(
        "times",
        "arial")
      )
font(jams4)
}
\seealso{
Other formatting functions: \code{\link{background_color}},
  \code{\link{bold}}, \code{\link{font_size}},
  \code{\link{na_string}}, \code{\link{number_format}},
  \code{\link{text_color}}
}
\concept{formatting functions}
