% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set-outer.R
\name{set-outer}
\alias{set-outer}
\alias{set_outer_borders}
\alias{set_outer_border_colors}
\alias{set_outer_border_styles}
\alias{set_outer_padding}
\title{Set borders and padding around a rectangle of cells}
\usage{
set_outer_borders(ht, row, col, value = 0.4)

set_outer_border_colors(ht, row, col, value)

set_outer_border_styles(ht, row, col, value)

set_outer_padding(ht, row, col, value)
}
\arguments{
\item{ht}{A huxtable.}

\item{row}{A row specifier. See \link{rowspecs} for details.}

\item{col}{An optional column specifier.}

\item{value}{Border width, color, style or a \code{\link[=brdr]{brdr()}} object. See \link{borders}.
For padding, padding width in points.}
}
\description{
Set borders and padding around a rectangle of cells
}
\details{
\code{set_outer_borders} sets borders round the top, bottom, left and
right of a group of cells. Behaviour is undefined unless \code{row} and \code{col}
specify contiguous sequences. \code{set_outer_border_colors} and
\code{set_outer_border_styles} set border colors and styles. \code{set_outer_padding}
sets padding, i.e. top padding on the top row of cells, etc.
}
\examples{
ht2 <- huxtable(a = 1:3, b = 1:3)
set_outer_borders(ht2)
set_outer_borders(ht2, 2:3, 1:2)

}
