% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties-border-generics.R
\name{border-styles}
\alias{border-styles}
\alias{map_left_border_style}
\alias{set_left_border_style}
\alias{map_right_border_style}
\alias{set_right_border_style}
\alias{map_top_border_style}
\alias{set_top_border_style}
\alias{map_bottom_border_style}
\alias{set_bottom_border_style}
\alias{left_border_style<-}
\alias{right_border_style<-}
\alias{top_border_style<-}
\alias{bottom_border_style<-}
\alias{left_border_style}
\alias{right_border_style}
\alias{top_border_style}
\alias{bottom_border_style}
\alias{`left_border_style<-`}
\alias{`right_border_style<-`}
\alias{`top_border_style<-`}
\alias{`bottom_border_style<-`}
\title{Set border styles}
\usage{
left_border_style(ht)
left_border_style(ht) <- value
set_left_border_style(ht, row, col, value )
map_left_border_style(ht, row, col, fn)

right_border_style(ht)
right_border_style(ht) <- value
set_right_border_style(ht, row, col, value )
map_right_border_style(ht, row, col, fn)

top_border_style(ht)
top_border_style(ht) <- value
set_top_border_style(ht, row, col, value )
map_top_border_style(ht, row, col, fn)

bottom_border_style(ht)
bottom_border_style(ht) <- value
set_bottom_border_style(ht, row, col, value )
map_bottom_border_style(ht, row, col, fn)
}
\arguments{
\item{ht}{A huxtable.}

\item{row}{A row specifier. See \link{rowspecs} for details.}

\item{col}{An optional column specifier.}

\item{fn}{A mapping function. See \link{mapping-functions} for details.}

\item{value}{One of \code{"solid"}, \code{"double"}, \code{"dashed"} or \code{"dotted"}.}
}
\description{
These functions set border styles.
}
\details{
Borders are always "collapsed": \code{right_border_style(ht)[, 1]} is
the same as \code{left_border_style(ht)[, 2]}, and setting one sets the other.
}
\section{Limitations}{

\itemize{
\item In HTML, you will need to set a width of at least 3 to get a double border.
\item Only "solid" and "double" styles are currently implemented in LaTeX.
}
}

\examples{

jams <- set_all_borders(jams)
bottom_border_style(jams)[1, ] <- "dotted"
jams

set_bottom_border_style(jams, "double")

}
\seealso{
\link{set-multiple}, \code{\link[=brdr]{brdr()}}

Other border properties: 
\code{\link{border-colors}},
\code{\link{borders}}
}
\concept{border properties}
