% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/screen.R
\name{print_screen}
\alias{print_screen}
\alias{to_screen}
\alias{to_screen.huxtable}
\title{Print a huxtable on screen}
\usage{
print_screen(ht, ...)

to_screen(ht, ...)

\method{to_screen}{huxtable}(
  ht,
  min_width = ceiling(getOption("width")/6),
  max_width = getOption("width", Inf),
  compact = TRUE,
  colnames = TRUE,
  color = getOption("huxtable.color_screen", default = TRUE),
  ...
)
}
\arguments{
\item{ht}{A huxtable.}

\item{...}{Passed on to \code{to_screen}.}

\item{min_width}{Minimum width in on-screen characters of the result.}

\item{max_width}{Maximum width in on-screen characters of the result. Overrides \code{min_width}.}

\item{compact}{Logical. To save space, don't print lines for empty horizontal borders.}

\item{colnames}{Logical. Whether or not to print colum names.}

\item{color}{Logical. Whether to print the huxtable in color (requires the \code{crayon} package).}
}
\value{
\code{to_screen} returns a string. \code{print_screen} prints the string and returns \code{NULL}.
}
\description{
Print a huxtable on screen
}
\details{
Screen display shows the following features:
\itemize{
\item Table and caption positioning
\item Merged cells
\item Cell alignment
\item Borders
\item Cell background and border color (if the "crayon" package is installed)
\item Text color, bold and italic (if the "crayon" package is installed)
}

Cell padding, widths and heights are not shown, nor are border styles.
}
\examples{
bottom_border(jams)[1, 1:2] <- 1
bold(jams)[1, 1:2] <- TRUE
jams <- map_text_color(jams,
      by_regex("berry" = "red"))

print_screen(jams)
}
\seealso{
Other printing functions: 
\code{\link{print_html}()},
\code{\link{print_latex}()},
\code{\link{print_md}()},
\code{\link{print_rtf}()}
}
\concept{printing functions}
