% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createTiles.R
\name{createTiles}
\alias{createTiles}
\title{Function to split large areas (\code{sfc_POLYGON}) into
tiles}
\usage{
createTiles(x, size_x, size_y, subset = TRUE)
}
\arguments{
\item{x}{has to by type \code{sf}.}

\item{size_x}{tile size along the x-axis in the units of the current projection (\code{numeric}).}

\item{size_y}{tile size along the y-axis in the units of the current projection (\code{numeric}).}

\item{subset}{\code{boolean} determining whether all or only intersecting tiles are returned.}
}
\value{
\code{sf} object containing tiles covering \code{x}.
}
\description{
To simplify and accelerate the computation of flood duration
with \code{\link{flood3}} in massive areas this function provides a simple
tiling algorithm.
}
\examples{
  options("hydflood.datadir" = tempdir())
  library(hydflood)
  tiles <- createTiles(x = sf.af(name = "Elbe"),
                       size_x = 10000, size_y = 10000)
  plot(tiles["tile_ID"])

}
