% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_shape_by_id.R
\name{get_shape_by_id}
\alias{get_shape_by_id}
\title{Link IDs to warterbody shapefiles}
\usage{
get_shape_by_id(match_id, feature_type = c("flowline", "waterbody"),
  dataset = c("nhdh", "nhdplusv2", "hydrolakes"), match_column)
}
\arguments{
\item{match_id}{ids of features to be matched.}

\item{feature_type}{name of feature layer to match. The hydrolakes dataset does not include a flowline layer.}

\item{dataset}{name of dataset to use for matching.}

\item{match_column}{index containing match ids. Defaults to dataset ID column.
Columns indexed by dataset:
\tabular{lll}{
nhdh \tab nhdplusv2 \tab hydrolakes \cr
PERMANENT_ \tab COMID \tab Hylak_id \cr
GNIS_ID \tab GNIS_ID \tab Lake_name \cr
GNIS_NAME \tab GNIS_NAME \cr
REACHCODE \tab REACHCODE
}}
}
\value{
simple features object containing polygons with associated IDs.
}
\description{
Get shapefiles containing waterbodies with specified IDs. If one argument is provided, no
other arguments will be used to filter. Arguments are checked in order: PERMANENT_match, GNIS_ID_match,
GNIS_NAME_match, REACHCODE_match.
}
\examples{
\dontrun{

library(sf)
shp = get_shape_by_id('143249470', feature_type = 'waterbody', dataset='nhdh')
plot(st_geometry(shp), col='blue')

}
}
