% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_streamorder-level.R
\name{add_streamlevel}
\alias{add_streamlevel}
\alias{add_streamlevel.data.frame}
\alias{add_streamlevel.hy}
\title{Add Streamlevel}
\usage{
add_streamlevel(x, coastal = NULL)

\method{add_streamlevel}{data.frame}(x, coastal = NULL)

\method{add_streamlevel}{hy}(x, coastal = NULL)
}
\arguments{
\item{x}{data.frame network compatible with \link{hydroloom_names}.}

\item{coastal}{character attribute name containing a logical flag
indicating if a given terminal catchment flows to the coast of is an
inland sink. If no coastal flag is included, all terminal paths are
assumed to be coastal.}
}
\value{
data,frame containing added \code{stream_level} attribute
}
\description{
Applies a topological sort and calculates stream level.
Algorithm: Terminal level paths are assigned level 1 (see note 1).
Paths that terminate at a level 1 are assigned level 2. This pattern is
repeated until no paths remain.

If a TRUE/FALSE coastal attribute is included, coastal terminal paths
begin at 1 and internal terminal paths begin at 4 as is implemented by
the NHD stream leveling rules.
}
\examples{
x <- sf::read_sf(system.file("extdata/new_hope.gpkg", package = "hydroloom"))

x <- add_toids(x)

y <- add_streamlevel(x)

plot(sf::st_geometry(y), lwd = y$streamlevel, col = "blue")

x$coastal <- rep(FALSE, nrow(x))

y <- add_streamlevel(x, coastal = "coastal")

unique(y$streamlevel)

x$coastal[!x$Hydroseq == min(x$Hydroseq)] <- TRUE

y <- add_streamlevel(x)

unique(y$streamlevel)

}
