% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ncdf.R
\name{downscaleNcdf}
\alias{downscaleNcdf}
\title{Downscale NetCDF file}
\usage{
downscaleNcdf(gridData, year = NULL, month = NULL, lon = NULL,
  lat = NULL)
}
\arguments{
\item{gridData}{A hyfo list file from \code{\link{loadNcdf}}}

\item{year}{A vector of the target year. e.g. \code{year = 2000}, \code{year = 1980:2000}}

\item{month}{A vector of the target month. e.g. \code{month = 2}, \code{month = 3:12}}

\item{lon}{A vector of the range of the downscaled longitude, should contain a max value
and a min value. e.g. \code{lon = c(-1.5, 2,5)}}

\item{lat}{A vector of the range of the downscaled latitude, should contain a max value
and a min value. e.g. \code{lat = c(32,2, 36)}}
}
\value{
A downscaled hyfo list file.
}
\description{
Downscale NetCDF file
}
\examples{
# First open the test NETcDF file.
filePath <- system.file("extdata", "tnc.nc", package = "hyfo")


# Then if you don't know the variable name, you can use \\code{getNcdfVar} to get variable name
varname <- getNcdfVar(filePath)

nc <- loadNcdf(filePath, varname)

# Then write to your work directory

nc1 <- downscaleNcdf(nc, year = 2006, lon = c(-2, -0.5), lat = c(43.2, 43.7))
nc2 <- downscaleNcdf(nc, year = 2005, month = 3:8, lon = c(-2, -0.5), lat = c(43.2, 43.7))

# More examples can be found in the user manual on http://yuanchao-xu.github.io/hyfo/
}
\references{
\itemize{

\item Santander MetGroup (2015). ecomsUDG.Raccess: R interface to the ECOMS User Data Gateway. R package
version 2.2-6. http://meteo.unican.es/ecoms-udg
}
}

