% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iARPermutation.R
\name{iARPermutation}
\alias{iARPermutation}
\title{Test for the significance of the autocorrelation estimated by the iAR package models}
\usage{
iARPermutation(
  series,
  times,
  series_esd = 0,
  iter = 100,
  coef,
  model = "iAR",
  plot = TRUE,
  xlim = c(-1, 0),
  df = 3
)
}
\arguments{
\item{series}{Array with the time series observations.}

\item{times}{Array with the irregular observational times.}

\item{series_esd}{Array with the variance of the measurement errors.}

\item{iter}{Number of disordered samples of the original data (N).}

\item{coef}{autocorrelation estimated by one of the iAR package models.}

\item{model}{model used to estimate the autocorrelation parameter ("iAR", "iAR-Gamma", "iAR-T", "CiAR" or "BiAR").}

\item{plot}{logical; if true, the function return a density plot of the distribution of the bad fitted examples; if false, this function does not return a plot.}

\item{xlim}{The x-axis limits (x1, x2) of the plot. Only works if plot='TRUE'. See \code{\link{plot.default}} for more details.}

\item{df}{degrees of freedom parameter of the iAR-T model.}
}
\value{
A list with the following components:
\item{coef}{ MLE of the autocorrelation parameter of the model.}
\item{bad}{ MLEs of the autocorrelation parameters of the models that has been fitted to the disordered samples.}
\item{norm}{ Mean and variance of the normal distribution of the disordered data.}
\item{z0}{ Statistic of the test (log(abs(phi))).}
\item{pvalue}{ P-value computed for the test.}
}
\description{
This function perform a test for the significance of the autocorrelation estimated by the iAR package models. This test is based in to take N disordered samples of the original data.
}
\details{
The null hypothesis of the test is: The autocorrelation coefficient estimated for the time series belongs to the distribution of the coefficients estimated on the disordered data, which are assumed to be uncorrelated. Therefore, if the hypothesis is accepted, it can be concluded that the observations of the time series are uncorrelated.The statistic of the test is log(phi) which was contrasted with a normal distribution with parameters corresponding to the log of the mean and the variance of the phi computed for the N samples of the disordered data. This test differs for \code{\link{iARTest}} in that to perform this test it is not necessary to know the period of the time series.
}
\examples{
data(Planets)
t<-Planets[,1]
res<-Planets[,2]
y=res/sqrt(var(res))
#res3=iARloglik(y,t,standardized=TRUE)[1]
#res3$coef
#set.seed(6713)
#require(ggplot2)
#test<-iARPermutation(series=y,times=t,coef=res3$coef,model="iAR",plot=TRUE,xlim=c(-9.6,-9.45))
}
\references{
\insertRef{Eyheramendy_2018}{iAR}
}
\seealso{
\code{\link{Planets}},\code{\link{iARTest}}
}
