% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LRtox.nTTP.R
\name{LRtox.nTTP}
\alias{LRtox.nTTP}
\title{Calculates likelihood of safety for single dose, using nTTP}
\usage{
LRtox.nTTP(tox_grades, ntox, coh.size, W, p1, p2, K = 2,
  std.nTTP = 0.15)
}
\arguments{
\item{tox_grades}{data frame of observed AE grades for each patient (rows) across all toxicity types (columns).
e.g. for one patient, grades for 3 toxicity types might be c(3, 2, 4), where they experienced a grade 3 AE for tox type 1,
grade 2 AE for tox type 2, etc.}

\item{ntox}{number (integer) of different toxicity types}

\item{coh.size}{cohort size (number of patients) per dose (Stage 1)}

\item{W}{matrix defining burden weight of each grade level for all toxicity types. 
The dimensions are ntox rows by 5 columns (for grades 0-4).
See Ezzalfani et al. (2013) for details.}

\item{p1}{toxicity under null (unsafe DLT rate). Values range from 0 - 1.}

\item{p2}{toxicity under alternative (safe DLT rate). Values range from 0 - 1; p1 > p2}

\item{K}{threshold for LR. Takes integer values: 1,2,...(recommended K=2)}

\item{std.nTTP}{the standard deviation of nTTP scores at each dose level (constant across doses)}
}
\value{
List object that gives the likelihood ratio of safety and indicates whether to escalate to the 
next highest dose level, or stop dose escalation and move onto stage 2.
}
\description{
(nTTP) Function \code{LRtox.nTTP()} calculates the likelihood of safety for a single dose 
and designates whether to escalate to the next dose (safe) or stop dose escalation and move onto stage 2 (unsafe).
}
\examples{
ntox = 3 # three different types of toxicity 
coh.size = 3 # number of patients enrolled per dose

# Observed AE grades for each patient on tested dose
obs = data.frame(tox1 = c(3, 2, 4),
                 tox2 = c(1, 1, 2),
                 tox3 = c(2, 3, 3))
                
# Toxicity burden weight matrix
W = matrix(c(0, 0.5, 0.75, 1.0, 1.5, # Burden weight for grades 0-4 for toxicity 1
             0, 0.5, 0.75, 1.0, 1.5, # Burden weight for grades 0-4 for toxicity 2
             0, 0.00, 0.00, 0.5, 1), # Burden weight for grades 0-4 for toxicity 3
             nrow = ntox, byrow = TRUE) 
             
# Acceptable (p2) and unacceptable nTTP values
p1 <- 0.35                                     
p2 <- 0.10       
             
LRtox.nTTP(obs, ntox, coh.size, W, p1, p2, K = 2, std.nTTP = 0.15)                                

}
