% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotD3_shap.R
\name{plotD3.shap}
\alias{plotD3.shap}
\title{Plot Shap (Break Down Uncertainty) Objects in D3 with r2d3 package.}
\usage{
\method{plotD3}{shap}(
  x,
  ...,
  baseline = NA,
  max_features = 10,
  digits = 3,
  rounding_function = round,
  bar_width = 12,
  margin = 0.2,
  scale_height = FALSE,
  min_max = NA,
  vcolors = NA,
  chart_title = NA,
  time = 0,
  max_vars = NULL
)
}
\arguments{
\item{x}{an explanation created with \code{\link{shap}}}

\item{...}{other parameters.}

\item{baseline}{if numeric then veritical line will start in \code{baseline}.}

\item{max_features}{maximal number of features to be included in the plot. By default it's \code{10}.}

\item{digits}{number of decimal places (\code{\link{round}}) or significant digits (\code{\link{signif}}) to be used.
See the \code{rounding_function} argument.}

\item{rounding_function}{a function to be used for rounding numbers.
This should be \code{\link{signif}} which keeps a specified number of significant digits or \code{\link{round}} (which is default) to have the same precision for all components.}

\item{bar_width}{width of bars in px. By default it's 12px}

\item{margin}{extend x axis domain range to adjust the plot. Usually value between 0.1 and 0.3, by default it's 0.2}

\item{scale_height}{if \code{TRUE}, the height of the plot scales with window size.}

\item{min_max}{a range of OX axis. By deafult \code{NA} therefore will be extracted from the contributions of \code{x}.
But can be set to some constants, usefull if these plots are used for comparisons.}

\item{vcolors}{If \code{NA} (default), DrWhy colors are used.}

\item{chart_title}{a character. Set custom title}

\item{time}{in ms. Set the animation length}

\item{max_vars}{alias for the \code{max_features} parameter.}
}
\value{
a \code{r2d3} object.
}
\description{
Plots Shapley values.
}
\examples{
library("DALEX")
library("iBreakDown")
set.seed(1313)
model_titanic_glm <- glm(survived ~ gender + age + fare,
                       data = titanic_imputed, family = "binomial")
explain_titanic_glm <- explain(model_titanic_glm,
                           data = titanic_imputed,
                           y = titanic_imputed$survived,
                           label = "glm")

s_glm <- shap(explain_titanic_glm, titanic_imputed[1, ])
s_glm
plotD3(s_glm)

\dontrun{
## Not run:
library("randomForest")

HR_small <- HR[2:500,]
m_rf <- randomForest(status ~. , data = HR_small)
new_observation <- HR_test[1,]
new_observation

p_fun <- function(object, newdata){predict(object, newdata=newdata, type = "prob")}

s_rf <- shap(m_rf,
             data = HR_small[,-6],
             new_observation =  new_observation,
             predict_function = p_fun)

plotD3(s_rf, time = 500)
}
}
\references{
Explanatory Model Analysis. Explore, Explain and Examine Predictive Models. \url{https://pbiecek.github.io/ema}
}
