% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F008.norm.data.R
\name{norm.data}
\alias{norm.data}
\title{Normalize data}
\usage{
norm.data(x = NULL, norm.method = "ranked.glsf", top.rank = 500,
  spike.in.factors = NULL, rpm.factor = 1000)
}
\arguments{
\item{x}{An object of class iCellR.}

\item{norm.method}{Choose a normalization method, there are three option currently.
Choose from "global.glsf", "ranked.glsf","spike.in" or no.norm, default = "ranked.glsf".}

\item{top.rank}{If the method is set to "ranked.glsf", you need to set top number of genes sorted based on global base mean, default = 500.}

\item{spike.in.factors}{A numeric vector of spike-in values with the same cell id order as the main data.}

\item{rpm.factor}{If the norm.method is set to "rpm" the library sizes would be diveded by this number, default = 1000 (higher numbers recomanded for bulk RNA-Seq).}
}
\value{
An object of class iCellR.
}
\description{
This function takes an object of class iCellR and normalized the data based on "global.glsf", "ranked.glsf" or "spike.in" methods.
}
\examples{

demo.obj <- norm.data(demo.obj, norm.method = "ranked.glsf", top.rank = 500)

}
