% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F0048.R
\name{pseudotime.knetl}
\alias{pseudotime.knetl}
\title{iCellR KNN Network}
\usage{
pseudotime.knetl(
  x = NULL,
  dist.method = "euclidean",
  k = 5,
  abstract = TRUE,
  data.type = "pca",
  dims = 1:20,
  conds.to.plot = NULL,
  my.layout = "layout_with_fr",
  node.size = 10,
  cluster.membership = FALSE,
  interactive = TRUE,
  node.colors = NULL,
  edge.color = "gray",
  out.name = "Pseudotime.Abstract.KNetL",
  my.seed = 1
)
}
\arguments{
\item{x}{An object of class iCellR.}

\item{dist.method}{the distance measure to be used to compute the dissimilarity matrix. This must be one of: "euclidean", "maximum", "mandatattan", "canberra", "binary", "minkowski" or "NULL". By default, distance="euclidean". If the distance is "NULL", the dissimilarity matrix (diss) should be given by the user. If distance is not "NULL", the dissimilarity matrix should be "NULL".}

\item{k}{KNN the higher the number the less sensitivity, default = 5.}

\item{abstract}{Draw all the cells or clusters, , default = TRUE.}

\item{data.type}{Choose between "tsne", "pca", "umap", default = "pca". We highly recommend PCA.}

\item{dims}{PCA dimentions to be use for clustering, default = 1:20.}

\item{conds.to.plot}{Choose the conditions you want to see in the plot, default = NULL (all conditions).}

\item{my.layout}{Choose a layout, default = "layout_with_fr".}

\item{node.size}{Size of the nodes, , default = 10.}

\item{cluster.membership}{Calculate memberships based on distance.}

\item{interactive}{If set to TRUE an interactive HTML file will be created, default = TRUE.}

\item{node.colors}{Color of the nodes, default = random colors.}

\item{edge.color}{Solor of the edges, default = "gray".}

\item{out.name}{If "interactive" is set to TRUE, the out put name for HTML, default = "Abstract.KNetL".}

\item{my.seed}{seed number, default = 1.}
}
\value{
A plot.
}
\description{
This function takes an object of class iCellR and and runs kNet for dimensionality reduction.
}
