% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rlapjv.R
\name{lapjv}
\alias{lapjv}
\alias{lapmod}
\title{Solves a linear assignment problem using the Jonker-Vogenant algorithm or LAPMOD variant}
\usage{
lapjv(cost, maximize = FALSE)

lapmod(cost, maximize = FALSE)
}
\arguments{
\item{cost}{For lapjv, an object that can be coerced to a matrix. For lapmod, a sparseMatrix.}

\item{maximize}{If FALSE (default) then costs are minimized and if TRUE the
costs are maximized}
}
\value{
The assignment of rows to columns as a vector.
}
\description{
Find the matching of rows to columns that minimizes or maximizes
the cost. See \link{do_lap} for usage.
}
\details{
The C++ code for these method is modified from code in the
 \href{https://github.com/Bram94/lapjv}{python lapjv} package.

 The cost matrix is padded with a single row and column of very large entries that
 helps to avoid stability issues with the algorithms.
}
\references{
R. Jonker, A. Volgenant (1987). \emph{A shortest augmenting path algorithm
for dense and sparse linear assignment problems}. Computing, pages 325-340.

A. Volgenant (1996). \emph{Linear and Semi-Assignment Problems: A
  Core Oriented Approach}. Computer Ops Res., pages 917-932.
}
\keyword{internal}
