% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/limitsOfAgreement.R
\name{laWRBM}
\alias{laWRBM}
\title{MRMC analysis of within-reader between-modality limits of agreement}
\usage{
laWRBM(df, modalitiesToCompare, keyColumns = c("readerID", "caseID",
  "modalityID", "score"))
}
\arguments{
\item{df}{Data frame of observations, one per row. Columns identify random effects, fixed effects,
and the observation. Namely,
\itemize{
  \item \code{readerID:} The factor corresponding to the different readers in the study.
    The readerID is treated as a random effect.
  \item \code{caseID:} The factor corresponding to the different cases in the study.
    The caseID is treated as a random effect.
  \item \code{modalityID:} The factor corresponding to the different modalities in the study.
    The modalityID is treated as a fixed effect.
  \item \code{score:} The score given by the reader to the case for the modality indicated.
}}

\item{modalitiesToCompare}{The factors identifying the modalities to compare.}

\item{keyColumns}{Identify the factors corresponding to the readerID, caseID, modalityID, and score
(or alternative random and fixed effects).}
}
\description{
The core analysis is done by ustat11 with the difference kernel (kernelFlag = 2).
  This calculation can also be accomplished by ustat11 with the identity kernel (kernelFlag = 1),
  and the code to do that is provided after the return statement so it never gets exectuted.
}
