/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.hups;

public class RadicalInverse {
    private static final int NP = 168;
    private static final int PLIM = 1000;
    private static final int[] PRIMES = new int[]{2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97, 101, 103, 107, 109, 113, 127, 131, 137, 139, 149, 151, 157, 163, 167, 173, 179, 181, 191, 193, 197, 199, 211, 223, 227, 229, 233, 239, 241, 251, 257, 263, 269, 271, 277, 281, 283, 293, 307, 311, 313, 317, 331, 337, 347, 349, 353, 359, 367, 373, 379, 383, 389, 397, 401, 409, 419, 421, 431, 433, 439, 443, 449, 457, 461, 463, 467, 479, 487, 491, 499, 503, 509, 521, 523, 541, 547, 557, 563, 569, 571, 577, 587, 593, 599, 601, 607, 613, 617, 619, 631, 641, 643, 647, 653, 659, 661, 673, 677, 683, 691, 701, 709, 719, 727, 733, 739, 743, 751, 757, 761, 769, 773, 787, 797, 809, 811, 821, 823, 827, 829, 839, 853, 857, 859, 863, 877, 881, 883, 887, 907, 911, 919, 929, 937, 941, 947, 953, 967, 971, 977, 983, 991, 997};
    private static final int[] FAURE_LEMIEUX_FACTORS = new int[]{1, 1, 3, 3, 4, 9, 7, 5, 9, 18, 18, 8, 13, 31, 9, 19, 36, 33, 21, 44, 43, 61, 60, 56, 26, 71, 32, 77, 26, 95, 92, 47, 29, 61, 57, 69, 115, 63, 92, 31, 104, 126, 50, 80, 55, 152, 114, 80, 83, 97, 95, 150, 148, 55, 80, 192, 71, 76, 82, 109, 105, 173, 58, 143, 56, 177, 203, 239, 196, 143, 278, 227, 87, 274, 264, 84, 226, 163, 231, 177, 95, 116, 165, 131, 156, 105, 188, 142, 105, 125, 269, 292, 215, 182, 294, 152, 148, 144, 382, 194, 346, 323, 220, 174, 133, 324, 215, 246, 159, 337, 254, 423, 484, 239, 440, 362, 464, 376, 398, 174, 149, 418, 306, 282, 434, 196, 458, 313, 512, 450, 161, 315, 441, 549, 555, 431, 295, 557, 172, 343, 472, 604, 297, 524, 251, 514, 385, 531, 663, 674, 255, 519, 324, 391, 394, 533, 253, 717, 651, 399, 596, 676, 425, 261, 404, 691, 604, 274, 627, 777, 269, 217, 599, 447, 581, 640, 666, 595, 669, 686, 305, 460, 599, 335, 258, 649, 771, 619, 666, 669, 707, 737, 854, 925, 818, 424, 493, 463, 535, 782, 476, 451, 520, 886, 340, 793, 390, 381, 274, 500, 581, 345, 363, 1024, 514, 773, 932, 556, 954, 793, 294, 863, 393, 827, 527, 1007, 622, 549, 613, 799, 408, 856, 601, 1072, 938, 322, 1142, 873, 629, 1071, 1063, 1205, 596, 973, 984, 875, 918, 1133, 1223, 933, 1110, 1228, 1017, 701, 480, 678, 1172, 689, 1138, 1022, 682, 613, 635, 984, 526, 1311, 459, 1348, 477, 716, 1075, 682, 1245, 401, 774, 1026, 499, 1314, 743, 693, 1282, 1003, 1181, 1079, 765, 815, 1350, 1144, 1449, 718, 805, 1203, 1173, 737, 562, 579, 701, 1104, 1105, 1379, 827, 1256, 759, 540, 1284, 1188, 776, 853, 1140, 445, 1265, 802, 932, 632, 1504, 856, 1229, 1619, 774, 1229, 1300, 1563, 1551, 1265, 905, 1333, 493, 913, 1397, 1250, 612, 1251, 1765, 1303, 595, 981, 671, 1403, 820, 1404, 1661, 973, 1340, 1015, 1649, 855, 1834, 1621, 1704, 893, 1033, 721, 1737, 1507, 1851, 1006, 994, 923, 872, 1860};
    private static final int NRILIM = 1000;
    private int b;
    private double invb;
    private double logb;
    private int JMAX;
    private int co = 0;
    private double xx;
    private long ix;

    public RadicalInverse(int b, double x0) {
        this.b = b;
        this.invb = 1.0 / (double)b;
        this.logb = Math.log(b);
        this.JMAX = (int)(22.18070977791825 / this.logb);
        this.xx = x0;
        this.ix = this.computeI(x0);
    }

    private long computeI(double x) {
        int j;
        int[] digits = new int[this.JMAX];
        for (j = 0; j < this.JMAX && x > 5.0E-16; x -= (double)digits[j], ++j) {
            digits[j] = (int)(x *= (double)this.b);
        }
        long i = 0L;
        for (j = this.JMAX - 1; j >= 0; --j) {
            i = i * (long)this.b + (long)digits[j];
        }
        return i;
    }

    public static int[] getPrimes(int n) {
        int i;
        int[] prime = new int[n];
        int n1 = Math.min(168, n);
        for (i = 0; i < n1; ++i) {
            prime[i] = PRIMES[i];
        }
        if (168 < n) {
            i = 168;
            int candidate = 1001;
            while (i < n) {
                boolean moreTests;
                prime[i] = candidate;
                int j = 1;
                while ((moreTests = prime[j] <= candidate / prime[j]) && candidate % prime[j] > 0) {
                    ++j;
                }
                if (!moreTests) {
                    ++i;
                }
                candidate += 2;
            }
        }
        return prime;
    }

    public static double radicalInverse(int b, long i) {
        double radical;
        double digit = radical = 1.0 / (double)b;
        double inverse = 0.0;
        while (i > 0L) {
            inverse += digit * (double)(i % (long)b);
            digit *= radical;
            i /= (long)b;
        }
        return inverse;
    }

    public static int radicalInverseInteger(int b, double x) {
        int digit = 1;
        int inverse = 0;
        int precision = Integer.MAX_VALUE / (2 * b * b);
        while (x > 0.0 && inverse < precision) {
            int p = digit * b;
            double y = Math.floor(x * (double)p);
            inverse += digit * (int)y;
            x -= y / (double)p;
            digit *= b;
        }
        return inverse;
    }

    public static long radicalInverseLong(int b, double x) {
        long digit = 1L;
        long inverse = 0L;
        long precision = Long.MAX_VALUE / (long)(b * b * b);
        while (x > 0.0 && inverse < precision) {
            long p = digit * (long)b;
            double y = Math.floor(x * (double)p);
            inverse += digit * (long)y;
            x -= y / (double)p;
            digit *= (long)b;
        }
        return inverse;
    }

    public static double nextRadicalInverse(double invb, double x) {
        double ALMOST_ONE = 0.9999999999;
        double nextInverse = x + invb;
        if (nextInverse < 0.9999999999) {
            return nextInverse;
        }
        double digit1 = invb;
        double digit2 = invb * invb;
        while (x + digit2 >= 0.9999999999) {
            digit1 = digit2;
            digit2 *= invb;
        }
        return x + (digit1 - 1.0) + digit2;
    }

    public double nextRadicalInverse() {
        ++this.co;
        if (this.co >= 1000) {
            this.co = 0;
            this.ix += 1000L;
            this.xx = RadicalInverse.radicalInverse(this.b, this.ix);
            return this.xx;
        }
        double ALMOST_ONE = 0.9999999999;
        double nextInverse = this.xx + this.invb;
        if (nextInverse < 0.9999999999) {
            this.xx = nextInverse;
            return this.xx;
        }
        double digit1 = this.invb;
        double digit2 = this.invb * this.invb;
        while (this.xx + digit2 >= 0.9999999999) {
            digit1 = digit2;
            digit2 *= this.invb;
        }
        this.xx += digit1 - 1.0 + digit2;
        return this.xx;
    }

    public static void reverseDigits(int k, int[] bdigits, int[] idigits) {
        for (int l = 0; l < k; ++l) {
            idigits[l] = bdigits[k - l];
        }
    }

    public static int integerRadicalInverse(int b, int i) {
        int inverse = 0;
        while (i > 0) {
            inverse = inverse * b + i % b;
            i /= b;
        }
        return inverse;
    }

    public static int nextRadicalInverseDigits(int b, int k, int[] idigits) {
        int l;
        for (l = k - 1; l >= 0; --l) {
            if (idigits[l] != b - 1) {
                int n = l;
                idigits[n] = idigits[n] + 1;
                return k;
            }
            idigits[l] = 0;
        }
        if (l == 0) {
            idigits[k] = 1;
            return ++k;
        }
        return 0;
    }

    public static void getFaureLemieuxPermutation(int coordinate, int[] pi) {
        int f = FAURE_LEMIEUX_FACTORS[coordinate];
        int b = PRIMES[coordinate];
        for (int k = 0; k < pi.length; ++k) {
            pi[k] = f * k % b;
        }
    }

    public static void getFaurePermutation(int b, int[] pi) {
        if (b == 2) {
            pi[0] = 0;
            pi[1] = 1;
        } else if ((b & 1) != 0) {
            int i;
            RadicalInverse.getFaurePermutation(--b, pi);
            for (i = 0; i < b; ++i) {
                if (pi[i] < b / 2) continue;
                int n = i;
                pi[n] = pi[n] + 1;
            }
            for (i = b; i > b / 2; --i) {
                pi[i] = pi[i - 1];
            }
            pi[b / 2] = b / 2;
        } else {
            RadicalInverse.getFaurePermutation(b /= 2, pi);
            for (int i = 0; i < b; ++i) {
                int n = i;
                pi[n] = pi[n] * 2;
                pi[i + b] = pi[i] + 1;
            }
        }
    }

    public static double permutedRadicalInverse(int b, int[] pi, long i) {
        double radical;
        double digit = radical = 1.0 / (double)b;
        double inverse = 0.0;
        while (i > 0L) {
            inverse += digit * (double)pi[(int)(i % (long)b)];
            digit *= radical;
            i /= (long)b;
        }
        return inverse;
    }
}

