/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.stochprocess;

import umontreal.iro.lecuyer.probdist.BetaDist;
import umontreal.iro.lecuyer.probdist.GammaDist;
import umontreal.iro.lecuyer.randvar.BetaGen;
import umontreal.iro.lecuyer.randvar.GammaGen;
import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.stochprocess.GammaProcess;

public class GammaProcessBridge
extends GammaProcess {
    protected BetaGen Bgen;
    protected double mu2OverNu;
    protected double mu2dTOverNu;
    protected double[] bMu2dtOverNuL;
    protected double[] bMu2dtOverNuR;
    protected int[] wIndexList;
    protected int bridgeCounter = -1;

    public GammaProcessBridge(double s0, double mu, double nu, RandomStream stream) {
        this(s0, mu, nu, new GammaGen(stream, new GammaDist(1.0)), new BetaGen(stream, new BetaDist(1.0, 1.0)));
    }

    public GammaProcessBridge(double s0, double mu, double nu, GammaGen Ggen, BetaGen Bgen) {
        super(s0, mu, nu, Ggen);
        this.Bgen = Bgen;
        this.Bgen.setStream(Ggen.getStream());
        this.stream = Ggen.getStream();
    }

    public double nextObservation() {
        double s;
        if (this.bridgeCounter == -1) {
            s = this.x0 + GammaGen.nextDouble(this.stream, this.mu2dTOverNu, this.muOverNu);
            if (s <= this.x0) {
                s = this.setLarger(this.x0);
            }
            this.bridgeCounter = 0;
            this.observationIndex = this.d;
        } else {
            int j = this.bridgeCounter * 3;
            int oldIndexL = this.wIndexList[j];
            int newIndex = this.wIndexList[j + 1];
            int oldIndexR = this.wIndexList[j + 2];
            double y = BetaGen.nextDouble(this.stream, this.bMu2dtOverNuL[newIndex], this.bMu2dtOverNuR[newIndex], 0.0, 1.0);
            s = this.path[oldIndexL] + (this.path[oldIndexR] - this.path[oldIndexL]) * y;
            if (s <= this.path[oldIndexL]) {
                s = this.setLarger(this.path, oldIndexL, oldIndexR);
            }
            ++this.bridgeCounter;
            this.observationIndex = newIndex;
        }
        this.observationCounter = this.bridgeCounter + 1;
        this.path[this.observationIndex] = s;
        return s;
    }

    public double nextObservation(double nextT) {
        double s;
        if (this.bridgeCounter == -1) {
            this.t[this.d] = nextT;
            this.mu2dTOverNu = this.mu2OverNu * (this.t[this.d] - this.t[0]);
            s = this.x0 + GammaGen.nextDouble(this.stream, this.mu2dTOverNu, this.muOverNu);
            if (s <= this.x0) {
                s = this.setLarger(this.x0);
            }
            this.bridgeCounter = 0;
            this.observationIndex = this.d;
        } else {
            int j = this.bridgeCounter * 3;
            int oldIndexL = this.wIndexList[j];
            int newIndex = this.wIndexList[j + 1];
            int oldIndexR = this.wIndexList[j + 2];
            this.t[newIndex] = nextT;
            this.bMu2dtOverNuL[newIndex] = this.mu2OverNu * (this.t[newIndex] - this.t[oldIndexL]);
            this.bMu2dtOverNuR[newIndex] = this.mu2OverNu * (this.t[oldIndexR] - this.t[newIndex]);
            double y = BetaGen.nextDouble(this.stream, this.bMu2dtOverNuL[newIndex], this.bMu2dtOverNuR[newIndex], 0.0, 1.0);
            s = this.path[oldIndexL] + (this.path[oldIndexR] - this.path[oldIndexL]) * y;
            if (s <= this.path[oldIndexL]) {
                s = this.setLarger(this.path, oldIndexL, oldIndexR);
            }
            ++this.bridgeCounter;
            this.observationIndex = newIndex;
        }
        this.observationCounter = this.bridgeCounter + 1;
        this.path[this.observationIndex] = s;
        return s;
    }

    public double[] generatePath(double[] uniform01) {
        this.path[this.d] = this.x0 + GammaDist.inverseF(this.mu2dTOverNu, this.muOverNu, 10, uniform01[0]);
        for (int j = 0; j < 3 * (this.d - 1); j += 3) {
            int oldIndexL = this.wIndexList[j];
            int newIndex = this.wIndexList[j + 1];
            int oldIndexR = this.wIndexList[j + 2];
            double y = BetaDist.inverseF(this.bMu2dtOverNuL[newIndex], this.bMu2dtOverNuR[newIndex], 8, uniform01[1 + j / 3]);
            this.path[newIndex] = this.path[oldIndexL] + (this.path[oldIndexR] - this.path[oldIndexL]) * y;
            if (!(this.path[newIndex] <= this.path[oldIndexL])) continue;
            this.setLarger(this.path, oldIndexL, newIndex, oldIndexR);
        }
        this.observationIndex = this.d;
        this.observationCounter = this.d;
        return this.path;
    }

    public double[] generatePath() {
        this.path[this.d] = this.x0 + GammaGen.nextDouble(this.stream, this.mu2dTOverNu, this.muOverNu);
        for (int j = 0; j < 3 * (this.d - 1); j += 3) {
            int oldIndexL = this.wIndexList[j];
            int newIndex = this.wIndexList[j + 1];
            int oldIndexR = this.wIndexList[j + 2];
            double y = BetaGen.nextDouble(this.stream, this.bMu2dtOverNuL[newIndex], this.bMu2dtOverNuR[newIndex], 0.0, 1.0);
            this.path[newIndex] = this.path[oldIndexL] + (this.path[oldIndexR] - this.path[oldIndexL]) * y;
            if (!(this.path[newIndex] <= this.path[oldIndexL])) continue;
            this.setLarger(this.path, oldIndexL, newIndex, oldIndexR);
        }
        this.observationIndex = this.d;
        this.observationCounter = this.d;
        return this.path;
    }

    public void resetStartProcess() {
        this.observationIndex = 0;
        this.observationCounter = 0;
        this.bridgeCounter = -1;
    }

    protected void init() {
        super.init();
        if (this.observationTimesSet) {
            this.bMu2dtOverNuL = new double[this.d + 1];
            this.bMu2dtOverNuR = new double[this.d + 1];
            this.wIndexList = new int[3 * this.d];
            int[] ptIndex = new int[this.d + 1];
            int indexCounter = 0;
            ptIndex[0] = 0;
            ptIndex[1] = this.d;
            this.mu2OverNu = this.mu * this.mu / this.nu;
            this.mu2dTOverNu = this.mu2OverNu * (this.t[this.d] - this.t[0]);
            for (int powOfTwo = 1; powOfTwo <= this.d / 2; powOfTwo *= 2) {
                int j;
                for (j = powOfTwo; j >= 1; --j) {
                    ptIndex[2 * j] = ptIndex[j];
                }
                for (j = 1; j <= powOfTwo; ++j) {
                    int oldLeft = 2 * j - 2;
                    int oldRight = 2 * j;
                    int newIndex = (int)(0.5 * (double)(ptIndex[oldLeft] + ptIndex[oldRight]));
                    this.bMu2dtOverNuL[newIndex] = this.mu * this.mu * (this.t[newIndex] - this.t[ptIndex[oldLeft]]) / this.nu;
                    this.bMu2dtOverNuR[newIndex] = this.mu * this.mu * (this.t[ptIndex[oldRight]] - this.t[newIndex]) / this.nu;
                    ptIndex[oldLeft + 1] = newIndex;
                    this.wIndexList[indexCounter] = ptIndex[oldLeft];
                    this.wIndexList[indexCounter + 1] = newIndex;
                    this.wIndexList[indexCounter + 2] = ptIndex[oldRight];
                    indexCounter += 3;
                }
            }
            for (int k = 1; k < this.d; ++k) {
                if (ptIndex[k - 1] + 1 >= ptIndex[k]) continue;
                this.bMu2dtOverNuL[ptIndex[k - 1] + 1] = this.mu * this.mu * (this.t[ptIndex[k - 1] + 1] - this.t[ptIndex[k - 1]]) / this.nu;
                this.bMu2dtOverNuR[ptIndex[k - 1] + 1] = this.mu * this.mu * (this.t[ptIndex[k]] - this.t[ptIndex[k - 1] + 1]) / this.nu;
                this.wIndexList[indexCounter] = ptIndex[k] - 2;
                this.wIndexList[indexCounter + 1] = ptIndex[k] - 1;
                this.wIndexList[indexCounter + 2] = ptIndex[k];
                indexCounter += 3;
            }
        }
    }

    public void setStream(RandomStream stream) {
        super.setStream(stream);
        this.Bgen.setStream(stream);
        this.stream = stream;
    }
}

