% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{rv.pcor}
\alias{rv.pcor}
\title{Determining a (partial) RV coefficient}
\usage{
rv.pcor(cors, a, b, set = NULL)
}
\arguments{
\item{cors}{The result from rv.cor.matrix().}

\item{a}{Either an index or a string to identify dataset a.}

\item{b}{Either an index or a string to identify dataset b.}

\item{set}{Optional parameter to define the datasets that need to be partialized for.
If set consists of one dataset, then provide an index or a string to identify set.
If set consists of multiple datasets, then provide a vector of indices or a vector of strings.}
}
\value{
The (partial) RV coefficient.
}
\description{
Determines the RV coefficient RV(a, b) or the partial RV coefficient
RV(a, b | set).
}
\examples{
set.seed(2)
n = 100
p = 100
x1 = matrix(rnorm(n*p), n, p)
x2 = x1 + matrix(rnorm(n*p), n, p)
x3 = x2 + matrix(rnorm(n*p), n, p)
data = list(x1=x1, x2=x2, x3=x3)
config_matrices = compute.config.matrices(data)
cors = rv.cor.matrix(config_matrices)
rv.pcor(cors, "x1", "x3", "x2")
}
