% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iaibase.R
\name{fit}
\alias{fit}
\title{fit}
\usage{
fit(lnr, X, ...)
}
\arguments{
\item{lnr}{The learner or grid to fit.}

\item{X}{The features of the data.}

\item{...}{Other parameters, including zero or more target vectors as
required by the problem type. Refer to the Julia documentation for
available parameters.}
}
\description{
Fits a model to the training data
}
\details{
Julia Equivalent:
\href{https://docs.interpretable.ai/IAIBase/stable/reference/#IAI.fit!}{\code{IAI.fit!}}
}
\examples{
\donttest{
X <- iris[, 1:4]
y <- iris$Species
iai::iai_setup()
grid <- iai::grid_search(
    iai::optimal_tree_classifier(max_depth = 1),
)
iai::fit(grid, X, y)
}
}
