% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimaltrees.R
\name{copy_splits_and_refit_leaves}
\alias{copy_splits_and_refit_leaves}
\title{Copy the tree split structure from one learner into another and refit the
models in each leaf of the tree using the supplied data}
\usage{
copy_splits_and_refit_leaves(new_lnr, orig_lnr, ...)
}
\arguments{
\item{new_lnr}{The learner to modify and refit}

\item{orig_lnr}{The learner from which to copy the tree split structure}

\item{...}{Refer to the Julia documentation for available parameters}
}
\description{
Julia Equivalent:
\href{https://docs.interpretable.ai/v3.1.1/OptimalTrees/reference/#IAI.copy_splits_and_refit_leaves!}{\code{IAI.copy_splits_and_refit_leaves!}}
}
\section{IAI Compatibility}{

Requires IAI version 3.0 or higher.
}

\examples{
\dontrun{iai::copy_splits_and_refit_leaves(new_lnr, orig_lnr, ...)}

}
