% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ibdsim2-package.R
\docType{package}
\name{ibdsim2-package}
\alias{ibdsim2}
\alias{ibdsim2-package}
\title{ibdsim2: Simulation of Chromosomal Regions Shared by Family Members}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Simulation of segments shared identical-by-descent (IBD) by pedigree members. Using sex specific recombination rates along the human genome (Halldorsson et al. (2019) \doi{10.1126/science.aau1043}), phased chromosomes are simulated for all pedigree members. Applications include calculation of realised relatedness coefficients and IBD segment distributions. 'ibdsim2' is part of the 'ped suite' collection of packages for pedigree analysis. A detailed presentation of the 'ped suite', including a separate chapter on 'ibdsim2', is available in the book 'Pedigree analysis in R' (Vigeland, 2021, ISBN:9780128244302). A 'shiny' app for visualising and comparing IBD distributions is available at \url{https://magnusdv.shinyapps.io/ibdsim2-shiny/}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/magnusdv/ibdsim2}
  \item \url{https://magnusdv.github.io/pedsuite/}
  \item \url{https://magnusdv.shinyapps.io/ibdsim2-shiny/}
}

}
\author{
\strong{Maintainer}: Magnus Dehli Vigeland \email{m.d.vigeland@medisin.uio.no} (\href{https://orcid.org/0000-0002-9134-4962}{ORCID})

}
\keyword{internal}
