% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tuneTrain.R
\name{tuneTrain}
\alias{tuneTrain}
\title{Tuning and Training the Data}
\usage{
tuneTrain(
  data,
  y,
  p = 0.7,
  method = method,
  parallelComputing = FALSE,
  length = 10,
  control = "repeatedcv",
  number = 10,
  repeats = 10,
  process = c("center", "scale"),
  summary = multiClassSummary,
  positive,
  ...
)
}
\arguments{
\item{data}{object of class "data.frame" with target variable and predictor variables.}

\item{y}{character. Target variable.}

\item{p}{numeric. Proportion of data to be used for training. Default: 0.7}

\item{method}{character. Type of model to use for classification or regression.}

\item{parallelComputing}{logical. indicates whether to also use the parallel processing. Default: False}

\item{length}{integer. Number of values to output for each tuning parameter. If \code{search = "random"} is passed to \code{\link[caret]{trainControl}} through \code{...}, this becomes the maximum number of tuning parameter combinations that are generated by the random search. Default: 10.}

\item{control}{character. Resampling method to use. Choices include: "boot", "boot632", "optimism_boot", "boot_all", "cv", "repeatedcv", "LOOCV", "LGOCV", "none", "oob", timeslice, "adaptive_cv", "adaptive_boot", or "adaptive_LGOCV". Default: "repeatedcv". See \code{\link[caret]{train}} for specific details on the resampling methods.}

\item{number}{integer. Number of cross-validation folds or number of resampling iterations. Default: 10.}

\item{repeats}{integer. Number of folds for repeated k-fold cross-validation if "repeatedcv" is chosen as the resampling method in \code{control}. Default: 10.}

\item{process}{character. Defines the pre-processing transformation of predictor variables to be done. Options are: "BoxCox", "YeoJohnson", "expoTrans", "center", "scale", "range", "knnImpute", "bagImpute", "medianImpute", "pca", "ica", or "spatialSign". See \code{\link[caret]{preProcess}} for specific details on each pre-processing transformation. Default: c('center', 'scale').}

\item{summary}{expression. Computes performance metrics across resamples. For numeric \code{y}, the mean squared error and R-squared are calculated. For factor \code{y}, the overall accuracy and Kappa are calculated. See \code{\link[caret]{trainControl}} and \code{\link[caret]{defaultSummary}} for details on specification and summary options. Default: multiClassSummary.}

\item{positive}{character. The positive class for the target variable if \code{y} is factor. Usually, it is the first level of the factor.}

\item{...}{additional arguments to be passed to \code{createDataPartition}, \code{trainControl} and \code{train} functions in the package \code{caret}.}
}
\value{
A list object with results from tuning and training the model selected in \code{method}, together with predictions and class probabilities. The training and test data sets obtained from splitting the data are also returned.

If \code{y} is factor, class probabilities are calculated for each class. If \code{y} is numeric, predicted values are calculated.

A ROC curve is created if \code{y} is factor. Otherwise, a plot of residuals versus predicted values is created if \code{y} is numeric.

\code{tuneTrain} relies on packages \code{caret}, \code{ggplot2} and \code{plotROC} to perform the modelling and plotting.
}
\description{
tuneTrain splits the Data, it is an automatic function for tuning, training, and making predictions, it returns a list containing a model object, data frame and plot.
}
\details{
Types of classification and regression models available for use with \code{tuneTrain} can be found using \code{names(getModelInfo())}. The results given depend on the type of model used.

For classification models, class probabilities and ROC curve are given in the results. For regression models, predictions and residuals versus predicted plot are given. \code{y} should be converted to either factor if performing classification or numeric if performing regression before specifying it in \code{tuneTrain}.
}
\examples{
if(interactive()){
 data(septoriaDurumWC)
 knn.mod <- tuneTrain(data = septoriaDurumWC,y = 'ST_S',method = 'knn',positive = 'R')
 
 nnet.mod <- tuneTrain(data = septoriaDurumWC,y = 'ST_S',method = 'nnet',positive = 'R')

}
}
\seealso{
\code{\link[caret]{createDataPartition}},
 \code{\link[caret]{trainControl}},
 \code{\link[caret]{train}},
 \code{\link[caret]{predict.train}},
 \code{\link[ggplot2]{ggplot}},
 \code{\link[plotROC]{geom_roc}},
 \code{\link[plotROC]{calc_auc}}
}
\author{
Zakaria Kehel, Bancy Ngatia, Khadija Aziz
}
