% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/real.R
\name{icd_is_billable}
\alias{icd_is_billable}
\alias{icd_is_billable.icd9}
\alias{icd_is_billable.icd10cm}
\alias{icd_is_billable.icd10}
\alias{icd_is_billable.icd9cm}
\alias{icd_is_billable.default}
\title{Determine whether codes are billable leaf-nodes}
\usage{
icd_is_billable(x, short_code = icd_guess_short(x), ...)

\method{icd_is_billable}{icd9}(x, short_code = icd_guess_short(x),
  icd9cm_edition = icd9cm_latest_edition(), ...)

\method{icd_is_billable}{icd10cm}(x, short_code = icd_guess_short(x),
  icd10cm_edition = "2016", ...)

\method{icd_is_billable}{icd10}(x, short_code = icd_guess_short(x),
  icd10cm_edition = "2016", ...)

\method{icd_is_billable}{icd9cm}(x, short_code = icd_guess_short(x),
  icd9cm_edition = icd9cm_latest_edition(), nomatch = 0L, ...)

\method{icd_is_billable}{default}(x, short_code = icd_guess_short(x), ...)
}
\arguments{
\item{x}{input vector to test}

\item{short_code}{single logical value which determines whether the ICD-9
code provided is in short (\code{TRUE}) or decimal (\code{FALSE}) form.
Where reasonable, this is guessed from the input data.}

\item{icd9cm_edition}{single character string, default is "32" which is the
latest release from CMS. Currently anything from "23" to "32" is accepted.
Not numeric because there are possible cases with non-numeric names, e.g.
revisions within one year, although none currently implemented.}

\item{icd10cm_edition}{single character string. ICD-10-CM editions are
currently just the year of release.}

\item{nomatch}{integer value, passed to \code{match} default is 0.}

\item{icd10cm_edition}{single character string. ICD-10-CM editions are
currently just the year of release.}
}
\value{
logical vector of same length as input
}
\description{
Codes provided are compared to the most recent edition of the CMS list of
billable codes, or another edition if specified.
}
\section{Methods (by class)}{
\itemize{
\item \code{icd9}: Which of the given ICD-9 codes are leaf nodes in
ICD-9-CM. Currently assumes ICD-9 codes are ICD-9-CM

\item \code{icd10cm}: Which of the given ICD-10 codes are leaf nodes in
ICD-10-CM. Currently assumes ICD-10 codes are ICD-10-CM

\item \code{icd10}: Which of the given ICD-10 codes are leaf nodes in
ICD-10-CM. Currently assumes ICD-10 codes are ICD-10-CM

\item \code{icd9cm}: Which of the given ICD-9 codes are leaf nodes in
ICD-9-CM

\item \code{default}: Which of the given ICD codes are leaf nodes in
ICD version (9 vs 10) guessed from the codes themselves.
}}

\keyword{internal}
