% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R, R/resource.R
\name{set_icd_data_dir}
\alias{set_icd_data_dir}
\alias{get_icd_data_dir}
\title{Set up the data download cache, give permission to download data}
\usage{
set_icd_data_dir(path = NULL)

get_icd_data_dir(must_work = TRUE)
}
\arguments{
\item{path}{Path to a directory where cached online raw and parsed data will
be cached. It will be created if it doesn't exist.}

\item{must_work}{Logical, the default of \code{TRUE} will cause this to stop
with an error if a usable icd data directory cannot be found or set.}
}
\value{
The path to the resource directory, or \code{NULL} if it could not be
  found.

Invisibly returns the data path which was set, or NULL if not done.
}
\description{
This must be called by the user, as prompted on package attach with
\code{library(icd)}.
}
\section{Functions}{
\itemize{
\item \code{get_icd_data_dir}: Get the currently active data directory, and
check it exists and is writable.
}}

\examples{
\dontrun{
set_icd_data_dir()
# or choose another directory:
# set_icd_data_dir("/var/cache/icd.data")
# then you may use:
# download_all_icd_data()
# or let 'icd' download data when needed.
}
}
\seealso{
\code{\link{download_all_icd_data}}
}
