% Generated by roxygen2 (4.0.1): do not edit by hand
\name{icd9PartsRecompose}
\alias{icd9MajMinToDecimal}
\alias{icd9MajMinToParts}
\alias{icd9MajMinToShort}
\alias{icd9PartsRecompose}
\alias{icd9PartsToDecimal}
\alias{icd9PartsToShort}
\title{recompose major and minor parts into icd9 codes}
\usage{
icd9PartsRecompose(parts, isShort, invalidAction = icd9InvalidActions)

icd9PartsToShort(parts, invalidAction = icd9InvalidActions)

icd9PartsToDecimal(parts, invalidAction = icd9InvalidActions)

icd9MajMinToParts(major, minor)

icd9MajMinToShort(major, minor, invalidAction = icd9InvalidActions)

icd9MajMinToDecimal(major, minor, invalidAction = icd9InvalidActions)
}
\arguments{
\item{parts}{data.frame with major and minor fields. This can be given
instead of major and minor vectors}

\item{isShort}{single logical value which determines whether the ICD-9 code provided is in short (TRUE) or decimal (FALSE) form.}

\item{invalidAction}{character string (unit length) containing one of:
  "ignore", "silent", "warn", "stop"

  - \code{ignore} no check for validity of ICD-9 code is made implicitly.
  This is the fastest option. If the function call is explicitly to check
  validity, e.g. icd9ValidShort(icd9Short = "12345", invalidAction =
  "ignore"), then the behavior is the same as \code{silent}.

  - \code{silent} invalid ICD-9 codes are replaced silently by \code{NA}
  (actually \code{NA_character_}). If the function returns \code{TRUE} or
  \code{FALSE} rather than the ICD-9 code itself, then \code{FALSE} is
  returned

  - \code{warn} invalid ICD-9 codes are replaced by \code{NA} with a warning
  revealing the invalid code(s).

  - \code{stop} stop with error if any invalid codes are found in input. This
  is the preferred method when doing one-time validation, e.g. of the
  co-morbidity mapping lists.}
}
\value{
character vector. Deliberately returns zero-padded major, because
  otherwise we are creating ambiguous codes (even if we know what we mean)
}
\description{
internal function which checks vector lengths to avoid
  unintentional recycling of vectors when lengths differ. Length of one is
  fine for major or minor.

icd9MajMinToDf simply composes the data frame needed
  as input to the PartsToXxxx functions

icd9MajMinTo\{Short|Decimal\} simply composes the data frame needed
  as input to the PartsToXxxx functions. Having two inputs breaks the ability to 'pipe' commands together using \link{magrittr}, so passing a single \code{data.frame} is preferred.
}
\seealso{
Other ICD-9 convert: \code{\link{icd9DecimalToShort}};
  \code{\link{icd9DropLeadingZeroes}},
  \code{\link{icd9DropLeadingZeroesDecimal}},
  \code{\link{icd9DropLeadingZeroesMajor}},
  \code{\link{icd9DropLeadingZeroesShort}};
  \code{\link{icd9ShortToDecimal}}
}
\keyword{internal}

