#' @docType package
#'
#' @name icesAdvice-package
#'
#' @aliases icesAdvice
#'
#' @title Functions Related to ICES Advice
#'
#' @description
#' Functions that are related to the advisory work of ICES (International
#' Council for the Exploration of the Sea).
#'
#' @details
#' \emph{Evaluate ICES advice:}
#' \tabular{ll}{
#'   \code{\link{DLS3.2}} \tab DLS method 3.2
#' }
#' \emph{Calculate PA reference points:}
#' \tabular{ll}{
#'   \code{\link{Bpa}} \tab from Blim\cr
#'   \code{\link{Fpa}} \tab from Flim
#' }
#' \emph{Calculate sigma:}
#' \tabular{ll}{
#'   \code{\link{sigmaCI}} \tab from confidence interval\cr
#'   \code{\link{sigmaPA}} \tab from PA reference points
#' }
#'
#' @author Arni Magnusson and Anne Cooper, with contributions by Colin Millar.
#'
#' @references
#' ICES advisory process:
#' \url{http://ices.dk/community/advisory-process/Pages/default.aspx}.

NA
