% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSAG.R
\name{getSAG}
\alias{getSAG}
\title{Get Any SAG Data}
\usage{
getSAG(stock, year, data = "summary", combine = TRUE)
}
\arguments{
\item{stock}{a stock name, e.g. cod-347d, or cod to find all cod stocks, or NULL to process all stocks.}

\item{year}{the assessment year, e.g. 2015, or 0 to process all years.}

\item{data}{the data of interest, either "summary" or "refpts".}

\item{combine}{whether to combine the list output to a data frame.}
}
\value{
A data frame (default) or a list if \code{combine} is \code{TRUE}.
}
\description{
This function combines the functionality of getListStocks,
getFishStockReferencePoints, and getSummaryTable.
It supports querying many stocks and years in one function call.
}
\note{
Only years with "Published" status are returned.
}
\examples{
summary <- getSAG("cod-347d", 2015)
refpts <- getSAG("cod-347d", 2015, "refpts")

\dontrun{
cod_summary <- getSAG("cod", 2015)
}
}
\seealso{
\code{\link{getListStocks}}, \code{\link{getSummaryTable}}, and
  \code{\link{getFishStockReferencePoints}} get a list of stocks, summary
  results, and reference points.

\code{\link{findKey}} finds lookup keys.

\code{\link{icesSAG-package}} gives an overview of the package.
}
