% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean.R
\name{clean}
\alias{clean}
\title{Clean TAF Directories}
\usage{
clean(dirs = c("data", "model", "output", "report"))
}
\arguments{
\item{dirs}{directories to delete.}
}
\description{
Remove TAF directories: \verb{data}, \verb{model}, \verb{output},
\verb{report}.
}
\note{
The purpose of removing the directories is to make sure that subsequent TAF
scripts start by creating new empty directories.

If any of the \code{dirs} is \code{"bootstrap"} it is treated specially.
Instead of completely removing the \verb{bootstrap} directory, only the
subdirectories \verb{data}, \verb{library}, and \verb{software} are removed.
This protects the subdirectory \verb{bootstrap/initial} and \verb{*.bib}
metadata files from being accidentally deleted.
}
\examples{
\dontrun{
clean()
}

}
\seealso{
\code{\link{mkdir}} and \code{\link{rmdir}} create and remove empty
directories.

\code{\link{sourceTAF}} and \code{\link{sourceAll}} run TAF scripts.

\code{\link{icesTAF-package}} gives an overview of the package.
}
