% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taf2xtab.R
\name{taf2xtab}
\alias{taf2xtab}
\title{Convert TAF Table to Crosstab Format}
\usage{
taf2xtab(x)
}
\arguments{
\item{x}{a data frame in TAF format.}
}
\value{
A data frame with years as row names.
}
\description{
Convert a table from TAF format to crosstab format.
}
\note{
TAF stores tables as data frames with a year column, as seen in stock
assessment reports. The crosstab format can be more convenient for analysis
and producing plots.
}
\examples{
taf2xtab(catage.taf)

}
\seealso{
\code{\link{catage.taf}} and \code{\link{catage.xtab}} describe the TAF and
crosstab formats.

\code{\link{tt}} converts a TAF table to transposed crosstab format.

\code{\link{xtab2taf}} converts a crosstab table to TAF format.

\code{\link{icesTAF-package}} gives an overview of the package.
}
