% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_sar.R
\name{get_sar}
\alias{get_sar}
\title{Download VMS data}
\usage{
get_sar(
  year,
  c_square,
  gear_code,
  stat_rec,
  ices_area,
  ecoregion,
  datacall = NULL
)
}
\arguments{
\item{year}{integer year}

\item{c_square}{character 0.05 degree c-square name}

\item{gear_code}{benthis gear code}

\item{stat_rec}{ICES statistical rectangle}

\item{ices_area}{ICES area}

\item{ecoregion}{ICES ecoregion}

\item{datacall}{integer year giving which data call year to inquire about.
If NULL returns the a summary of the most recent approved data.}
}
\value{
a data.frame of VMS data
}
\description{
RESTRICTED.  Only core members of the ICES VMS data call can access this data.
Download a data.frame of VMS swept area ratio values from the ICES VMS and logbook database.
}
\examples{
\dontrun{
# requires authorization
sar <- get_sar(2021, stat_rec = "40F1")
}

}
