% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/application.R
\docType{methods}
\name{trishape}
\alias{trishape}
\alias{trishape,hexagrid-method}
\alias{trishape,trigrid-method}
\title{Shape distortions of the triangular faces and subfaces}
\usage{
trishape(gridObj)

\S4method{trishape}{trigrid}(gridObj)

\S4method{trishape}{hexagrid}(gridObj)
}
\arguments{
\item{gridObj}{A \code{trigrid} or \code{hexagrid} object.}
}
\value{
A named numeric vector.
}
\description{
This function will return a value that is proportional to the irregularity of a triangonal face or subface.
}
\details{
The value is exactly 1 for an equilateral triangle, and becomes 0 as one of the edges approach 0.
}
\examples{
	g <- trigrid(3)
	shape <- trishape(g)
	trishape

}

