% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/application.R
\docType{methods}
\name{translate}
\alias{translate}
\alias{translate,hexagrid,numeric-method}
\alias{translate,trigrid,numeric-method}
\title{Translating the grid object in 3d Cartesian space}
\usage{
translate(gridObj, vec)

\S4method{translate}{trigrid,numeric}(gridObj, vec)

\S4method{translate}{hexagrid,numeric}(gridObj, vec)
}
\arguments{
\item{gridObj}{A \code{trigrid} or \code{hexagrid} class object.}

\item{vec}{A numeric vector of length 3. This is the translation vector.}
}
\value{
The same grid structure as the input, but with translated coordinates.
}
\description{
The function translates the coordinates of a grid object with the specified 3d vector.
}
\examples{
 # create a grid and plot it
g <- trigrid(3)
lines3d(g)
# translate the grid to (15000,15000,15000)
 g2 <- translate(g, c(15000,15000,15000))
	 lines3d(g2)

}

