% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importance_sampling.R
\name{ImpsampMNL}
\alias{ImpsampMNL}
\title{Importance sampling MNL}
\usage{
ImpsampMNL(prior.mean, prior.covar, des, n.alts, y, m, b = 2)
}
\arguments{
\item{prior.mean}{Numeric vector indicating the mean of the multivariate
normal distribution (prior).}

\item{prior.covar}{Covariance matrix of the prior distribution.}

\item{des}{A design matrix in which each row is a profile. Can be generated
with \code{\link{Modfed}}}

\item{n.alts}{Numeric value indicating the number of alternatives per choice
set.}

\item{y}{A binary response vector. \code{\link{RespondMNL}} can be used to
simulate respons data.}

\item{m}{Numeric value. Number of samples = \code{base^m}.}

\item{b}{Numeric value indicating the base. The default = 2.}
}
\value{
\item{samples}{Numeric vector with the (unweigthted) samples from the
posterior distribution.} \item{weights}{Numeric vector with the associated
weights of the samples.} \item{max}{Numeric vector with the estimated
mode of the posterior distribution.} \item{covar}{Matrix representing the
estimated variance covariance matrix.}
}
\description{
This function samples from the posterior distribution using importance
sampling, assuming a multivariate normal prior distribution and a MNL likelihood.
}
\examples{
# Importance sampling MNL 
pm <- c(0.8, 0.3, 0.2, -0.3, -0.2) # Prior mean (4 parameters).
pc <- diag(length(pm)) # Prior variance
cs <- Profiles(lvls = c(3, 3), coding = c("E", "E"))
ps <- MASS::mvrnorm(n = 10, mu = pm, Sigma = pc) # 10 Samples.
# Efficient design. 
design <- Modfed(cand.set = cs, n.sets = 8, n.alts = 2, alt.cte = c(1,0), par.draws = ps)$design
# Respons.
resp <- RespondMNL(par = c(0.7, 0.6, 0.5, -0.5, -0.7), des = design, n.alts = 2)
# Parameters samples from posterior.
ImpsampMNL(prior.mean =  pm, prior.covar = pc, des = design, n.alts = 2, y = resp, m = 6)

# Importance sampling MNL
pm <- c(0.3, 0.2, -0.3, -0.2) # Prior mean (4 parameters).
pc <- diag(length(pm)) # Prior variance
cs <- Profiles(lvls = c(3, 3, 2), coding = c("D", "C", "D"), c.lvls = list(c(2,4,6)))
ac <- c(0, 0) # No alternative specific constants. 
ps <- MASS::mvrnorm(n = 10, mu = pm, Sigma = pc) # 10 Samples.
# Efficient design. 
design <- Modfed(cand.set = cs, n.sets = 8, n.alts = 2, alt.cte = c(0,0), par.draws = ps)$design
# Respons
resp <- RespondMNL(par = c(0.6, 0.5, -0.5, -0.7), des = design, n.alts = 2)
# Parameters samples from posterior.
ImpsampMNL(prior.mean =  pm, prior.covar = pc, des = design, n.alts = 2, y = resp, m = 6)
}
