% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idem_imputation.R
\name{get.imp.all}
\alias{get.imp.all}
\title{Impute missing data}
\usage{
get.imp.all(data.all, fit.all, lst.var, endponly = TRUE, trace.n = 0,
  deltas = 0, ..., update.progress = NULL, imputeNone = FALSE)
}
\arguments{
\item{data.all}{Original dataset}

\item{fit.all}{A class \code{idem.fit} results of linear regression.
See \code{\link{fit.model}}.}

\item{lst.var}{see \code{\link{idem-parameters}}}

\item{endponly}{Logical variable indicating whether clinical outcomes not
used in calculating the final clinical outcome will be imputed. The
default is FALSE, indicating that all missing clinical outcomes will be
imputed sequentially}

\item{trace.n}{Number of subjects to impute in order to access convergence of
the MCMC chain. If \code{trace.n} is 0, all subjects will be imputed}

\item{deltas}{Vector of imputation sensitivity parameters}

\item{...}{Options for MCMC sampling including
\describe{
\item{normal}{Logical variable indicating whether normality assumption should be made for the residuals}
\item{n.imp}{number of imputed missing values for each subject}
\item{iter}{burn-in in the MCMC chain}
\item{thin}{thinning after burn-in}
\item{p.scale}{scale factor for the variances of the candidate
               normal distribution in random-walk Metroplis-Hasting
sampling} }}

\item{update.progress}{Parameter reserved for run \code{idem} in GUI mode}

\item{imputeNone}{If \code{TRUE}, return subjects that do not need imputation}
}
\value{
If \code{imputeNone} is TRUE, return a dataset with the original data for the
subset of subjects who died at the end of the study or had no missing outcomes.

If \code{trace.n >0}, return a list of MCMC sampling chains of the imputed
missing values for \code{trace.n} randomly selected subjects that need
imputation.

Otherwise, return a class \code{IDEM.IMP} dataset with the original data for the subset of subjects
who died at the end of the study or had no missing outcomes and the
\code{n.imp} imputed missing outcomes for subjects who need missing value
imputation.
}
\description{
Impute missing data for all the subjects or a small sample of the subjects
}
\examples{

\dontrun{
lst.var <- list(trt="TRT", surv="SURV", outcome=c("Y1","Y2"), y0=NULL,
                endp=c("Y2"), unitTime="days",
                trt.label = c("UC+SBT", "SAT+SBT"),
                cov=c("AGE"), endfml="Y2", duration=365, bounds=c(0,100));
rst.fit <- fit.model(abc, lst.var);
rst.imp <- get.imp.all(abc, rst.fit, lst.var, deltas=c(-0.25,0,0.25),
                       normal=TRUE, iter=300, n.imp=2, thin=1, p.scale=10);}

}

