% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idem_analysis.R
\name{imBs}
\alias{imBs}
\title{Boostrap analysis}
\usage{
imBs(imp.rst, n.boot = 100, n.cores = 1, update.progress = NULL,
  offset = 10000, quantiles = 0.5)
}
\arguments{
\item{imp.rst}{A class \code{IDEM.IMP} list containing complete data
with relevant missing values imputed. See \code{\link{imImpAll}}.}

\item{n.boot}{Number of bootstrap samples}

\item{n.cores}{Number of cores for parallel computation}

\item{update.progress}{Parameter reserved for run \code{idem} in GUI mode}

\item{offset}{A constant value to be added to survival days for reporting the
median value}

\item{quantiles}{Quantiles of the composite endpoint to be reported}
}
\value{
A class \code{IDEM.BOOT} list with length \code{n.boot+1}. Each item
    in the list is a class \code{{IDEM.RST}} list (see
    \code{\link{imEstimate}}). The first item correspons to the
    estimation result on the original dataset.
}
\description{
Boostrap analysis
}
\examples{

\dontrun{
lst.var  <- list(trt="TRT", surv="SURV", outcome=c("Y1","Y2"), y0=NULL,
                 endp=c("Y2"), unitTime="days",
                 trt.label = c("UC+SBT", "SAT+SBT"),
                 cov=c("AGE"), endfml="Y2", duration=365, bounds=c(0,100));
rst.fit <- imFitModel(abc, lst.var);
rst.imp <- imImpAll(abc, rst.fit, deltas=c(-0.25,0,0.25),
                    normal=TRUE, chains = 4, iter = 2000, warmup = 1000);
rst.boot <- imBs(rst.imp, n.boot = 10, n.cores = 5, quantiles = c(0.25,0.5,0.75));}

}
