% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_id.R
\name{clean_id}
\alias{clean_id}
\title{Clean ID}
\usage{
clean_id(data, cols = list(), FUN = list())
}
\arguments{
\item{data}{is a data.frame containing any number of columns.}

\item{cols}{is a list of integers or column names indicating the columns that are to be cleaned up.}

\item{FUN}{is a list of functions to pass to the specified columns (must be in same order as the column index)}
}
\value{
Returns a dataframe with replacements in the specified columns
}
\description{
Provides a method for applying both cleaning functions (clean_x and clean_case) to a dataframe by index.
}
\details{
This function is meant to be used on multiple columns at once. It makes use of the magrittr pipe operator to provide neat code.
}
\examples{
df <- data.frame(pbnum = c("PB123", "PB 0034", "  5678 ", "None"),
status = c("Active", "Closed", "Closed", "Active"),
xnum = c("X00123", "9512", "X789", "NOT IN APS"))

#' df \%>\% clean_id(cols = c(1,3), FUN = c("clean_case", "clean_x"))

#' clean_id(data = df, cols = c(1,3), FUN = c("clean_case", "clean_x"))
}
\seealso{
clean_x, clean_case
}

