% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corint.r
\name{corint}
\alias{corint}
\title{Intrinsic Dimension Estimation with Correlation Integral}
\usage{
corint(x, k1 = NULL, k2 = NULL, DM = FALSE, p = NULL)
}
\arguments{
\item{x}{data matrix or distance matrix given by as.matrix(dist(x)).}

\item{k1}{first k-NN parameter.}

\item{k2}{second k-NN parameter.}

\item{DM}{whether \code{'x'} is distance matrix or not. logical.}

\item{p}{ambient dimension used for automatically define \code{'k1'} and \code{'k2'}.}
}
\value{
Estimated global intrinsic dimension.
}
\description{
\code{corint} estimates intrinsic dimension of given dataset based on 
the correlation integral
}
\details{
A variant of fractal dimension called the correlation dimension is considered.
The correlation dimension is defined by the notion of the correlation integral, 
is calculated by using the power low for the definition of the correlation dimension.
}
\examples{
x <- gendata(DataName='SwissRoll',n=300)
estcorint <- corint(x=x,k1=5,k2=10)
print(estcorint)
}
\references{
P. Grassberger and I. Procaccia. Measuring the strangeness of strange attractors. 
Physica, 1983.
}
\author{
Hideitsu Hino \email{hideitsu.hino@gmail.com}
}
