% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise_strat_var.R
\name{summarise_strat_var}
\alias{summarise_strat_var}
\title{Sum a Stratified Variable}
\usage{
summarise_strat_var(df, vars, strat = NULL, new_var = "sum")
}
\arguments{
\item{df}{A dataframe of model output.}

\item{vars}{A character vector containing the unstratified variables to summarise}

\item{strat}{The number of stratifications present in the data set}

\item{new_var}{The name of the summarised variable}
}
\value{
Returns the original dataframe with an additional summarised variable
}
\description{
Sum a Stratified Variable
}
\examples{
df <- dplyr::mutate(iris, Petal.Length1 = Petal.Length, Petal.Length2 = Petal.Length)
df <- tibble::as_tibble(df)

summarise_strat_var(df, vars = c("Petal.Length"), strat = 2, new_var = "sum")
}
\seealso{
summarise_var_by_strat
}
