% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SEI.R
\name{SEI_demographics_ode}
\alias{SEI_demographics_ode}
\title{Susceptible-Exposed-Infected Model with Simple Demographics}
\usage{
SEI_demographics_ode(t, x, params)
}
\arguments{
\item{t}{The timestep over which to calculate derivatives}

\item{x}{A numeric vector of compartment populations.}

\item{params}{A named vector of parameter values.}
}
\value{
A vector of derivatives
}
\description{
Susceptible-Exposed-Infected Model with Simple Demographics
}
\examples{
##Model Input
S_0 <- 989
E_0 <- 10
I_0 <- 1
beta <- 3
gamma <- 1/2
mu <- 1/81

parameters <- c(beta = beta, gamma = gamma, mu = mu)
inits <- c(S = S_0, E = E_0, I = I_0)

SEI_demographics_ode(1, inits, parameters)
}
