% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-generics-volume.R
\name{as_ieegio_volume}
\alias{as_ieegio_volume}
\alias{as_ieegio_volume.character}
\alias{as_ieegio_volume.ieegio_volume}
\alias{as_ieegio_volume.array}
\alias{as_ieegio_volume.niftiImage}
\alias{as_ieegio_volume.nifti}
\alias{as_ieegio_volume.ants.core.ants_image.ANTsImage}
\title{Convert objects to \code{'ieegio'} image volumes}
\usage{
as_ieegio_volume(x, ...)

\method{as_ieegio_volume}{character}(x, ...)

\method{as_ieegio_volume}{ieegio_volume}(x, ...)

\method{as_ieegio_volume}{array}(x, vox2ras = NULL, as_color = is.character(x), ...)

\method{as_ieegio_volume}{niftiImage}(x, ...)

\method{as_ieegio_volume}{nifti}(x, ...)

\method{as_ieegio_volume}{ants.core.ants_image.ANTsImage}(x, ...)
}
\arguments{
\item{x}{R object such as array, image path, or objects such as
\code{'RNifti'} or \code{'oro.nifti'} image instances}

\item{...}{passed to other methods}

\item{vox2ras}{a \code{4x4} 'affine' matrix representing the transform
from 'voxel' index (column-row-slice) to 'RAS'
(right-anterior-superior) coordinate. This transform is often called
\code{'xform'}, \code{'sform'}, \code{'qform'} in 'NIfTI' terms, or
\code{'Norig'} in 'FreeSurfer'}

\item{as_color}{for converting arrays to volume, whether to treat \code{x}
as array of colors; default is true when \code{x} is a raster matrix (
matrix of color strings) and false when \code{x} is not a character array.}
}
\value{
An \code{ieegio} volume object; see \code{\link{imaging-volume}}
}
\description{
Convert array, path, or 'NIfTI' images in other formats to \code{'ieegio'}
image volume instance
}
\examples{


shape <- c(50, 50, 50)
vox2ras <- matrix(
  c(-1, 0, 0, 25,
    0, 0, 1, -25,
    0, -1, 0, 25,
    0, 0, 0, 1),
  nrow = 4, byrow = TRUE
)

# continuous
x <- array(rnorm(125000), shape)

volume <- as_ieegio_volume(x, vox2ras = vox2ras)
plot(volume, zoom = 3, pixel_width = 0.5)

# color rgb(a)
x <- array(
  sample(c("red","blue", "green", "cyan", "yellow"),
         12500, replace = TRUE),
  shape
)
rgb <- as_ieegio_volume(x, vox2ras = vox2ras)
plot(rgb, zoom = 3, pixel_width = 0.5)



}
