% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-generics-volume.R, R/mgz.R, R/nifti.R
\name{imaging-volume}
\alias{imaging-volume}
\alias{read_volume}
\alias{write_volume}
\alias{io_read_mgz}
\alias{io_write_mgz}
\alias{io_write_mgz.ieegio_volume}
\alias{io_write_mgz.ieegio_mgh}
\alias{io_write_mgz.nifti}
\alias{io_write_mgz.niftiImage}
\alias{io_write_mgz.ants.core.ants_image.ANTsImage}
\alias{io_write_mgz.array}
\alias{io_read_nii}
\alias{io_write_nii}
\alias{io_write_nii.ieegio_nifti}
\alias{io_write_nii.ants.core.ants_image.ANTsImage}
\alias{io_write_nii.niftiImage}
\alias{io_write_nii.nifti}
\alias{io_write_nii.ieegio_mgh}
\alias{io_write_nii.array}
\title{Read and write volume data}
\format{
format of the file; default is auto-detection, other choices are
\code{'nifti'} and \code{'mgh'};
}
\usage{
read_volume(file, header_only = FALSE, format = c("auto", "nifti", "mgh"), ...)

write_volume(x, con, format = c("auto", "nifti", "mgh"), ...)

io_read_mgz(file, header_only = FALSE)

io_write_mgz(x, con, ...)

\method{io_write_mgz}{ieegio_volume}(x, con, ...)

\method{io_write_mgz}{ieegio_mgh}(x, con, ...)

\method{io_write_mgz}{nifti}(x, con, ...)

\method{io_write_mgz}{niftiImage}(x, con, ...)

\method{io_write_mgz}{ants.core.ants_image.ANTsImage}(x, con, ...)

\method{io_write_mgz}{array}(x, con, vox2ras = NULL, ...)

io_read_nii(
  file,
  method = c("rnifti", "oro", "ants"),
  header_only = FALSE,
  ...
)

io_write_nii(x, con, ...)

\method{io_write_nii}{ieegio_nifti}(x, con, ...)

\method{io_write_nii}{ants.core.ants_image.ANTsImage}(x, con, ...)

\method{io_write_nii}{niftiImage}(x, con, ...)

\method{io_write_nii}{nifti}(x, con, gzipped = NA, ...)

\method{io_write_nii}{ieegio_mgh}(x, con, ...)

\method{io_write_nii}{array}(
  x,
  con,
  vox2ras = NULL,
  datatype_code = NULL,
  xyzt_units = c("NIFTI_UNITS_MM", "NIFTI_UNITS_SEC"),
  intent_code = "NIFTI_INTENT_NONE",
  ...,
  gzipped = NA
)
}
\arguments{
\item{file}{file path to read volume data}

\item{header_only}{whether to read header data only;
default is \code{FALSE}}

\item{format}{format of the file to be written; choices are \code{'auto'},
\code{'nifti'} or \code{'mgh'}; default is to \code{'auto'}
detect the format based on file names, which will save as a 'MGH' file
when file extension is \code{'mgz'} or \code{'mgh'}, otherwise 'NIfTI'
format. We recommend explicitly setting this argument}

\item{...}{passed to other methods}

\item{x}{volume data (such as 'NIfTI' image, array, or 'MGH')
to be saved}

\item{con}{file path to store image}

\item{vox2ras}{a \code{4x4} transform matrix from voxel indexing (column,
row, slice) to scanner (often 'T1-weighted' image) 'RAS'
(right-anterior-superior) coordinate}

\item{method}{method to read the file; choices are \code{'oro'} (using
\code{\link[oro.nifti]{readNIfTI}}), \code{'rnifti'} (using
\code{\link[RNifti]{readNifti}}), and \code{'ants'} (using
\code{\link[rpyANTs]{as_ANTsImage}}).}

\item{gzipped}{for writing \code{'nii'} data: whether the file needs to be
compressed; default is inferred from the file name. When the file ends
with \code{'nii'}, then no compression is used; otherwise the file will
be compressed. If the file name does not end with \code{'nii'} nor
\code{'nii.gz'}, then the file extension will be added automatically.}

\item{datatype_code, xyzt_units, intent_code}{additional flags for
'NIfTI' headers, for advanced users}
}
\value{
Imaging readers return \code{ieegio_volume} objects. The writers
return the file path to where the file is saved to.
}
\description{
Read and write volume data ('MRI', 'CT', etc.) in 'NIfTI' or 'MGH' formats.
Please use \code{read_volume} and \code{write_volume} for high-level
function. These functions
will call other low-level functions internally.
}
\examples{


library(ieegio)

nifti_file <- "brain.demosubject.nii.gz"

# Use `ieegio_sample_data(nifti_file)`
#   to download sample data


if( ieegio_sample_data(nifti_file, test = TRUE) ) {

# ---- NIfTI examples ---------------------------------------------

file <- ieegio_sample_data(nifti_file)

# basic read
vol <- read_volume(file)

# voxel to scanner RAS
vol$transforms$vox2ras

# to freesurfer surface
vol$transforms$vox2ras_tkr

# to FSL
vol$transforms$vox2fsl

plot(vol, position = c(10, 0, 30))

# ---- using other methods --------------------------------------
# default
vol <- read_volume(file, method = "rnifti", format = "nifti")
vol$header

# lazy-load nifti
vol2 <- read_volume(file, method = "oro", format = "nifti")
vol2$header

\dontrun{
# requires additional python environment

# Using ANTsPyx
vol3 <- read_volume(file, method = "ants", format = "nifti")
vol3$header

}

# ---- write --------------------------------------------------------

# write as NIfTI
f <- tempfile(fileext = ".nii.gz")

write_volume(vol, f, format = "nifti")

# alternative method
write_volume(vol$header, f, format = "nifti")

# write to mgz/mgh
f2 <- tempfile(fileext = ".mgz")

write_volume(vol, f, format = "mgh")

# clean up
unlink(f)
unlink(f2)

}

}
