% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cosd.R
\encoding{UTF-8}
\name{sind}
\alias{sind}
\title{Sine (in degrees) [GNU Octave/MATLAB compatible]}
\usage{
sind(x)
}
\arguments{
\item{x}{A numeric vector containing values in degrees}
}
\value{
The sine of each element of \code{x} in degrees. Zero for any
"elements where \code{x} / 180 is an integer."
}
\description{
Calculates the value of sine for each element of \code{x} in degrees in a
manner compatible with GNU Octave/MATLAB. Zero is returned for any "elements
where \code{x} / 180 is an integer." Source: Eaton.
}
\examples{
library(iemisc)

# Examples from GNU Octave sind
sind(seq(10, 90, by = 10))

sind(c(0, 180, 360))

sind(c(90, 270))


}
\references{
John W. Eaton, David Bateman, and Søren Hauberg (2009). \emph{GNU Octave version 3.0.1 manual: a high-level interactive language for numerical computations}. CreateSpace Independent Publishing Platform. ISBN 1441413006, URL \url{http://www.gnu.org/software/octave/doc/interpreter/}. Page 358.
}
\author{
David Bateman (GNU Octave sind), Irucka Embry
}
