% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frac_to_numeric.R
\encoding{UTF-8}
\name{frac_to_numeric}
\alias{frac_to_numeric}
\title{Fraction (or Mixed number) to a Decimal (Numeric Vector)}
\source{
removing all non-numeric characters from a string, but not "." - R help on nabble.com answered by David Winsemius on Jul 26, 2016. See \url{https://web.archive.org/web/20190730141421/http://r.789695.n4.nabble.com/removing-all-non-numeric-characters-from-a-string-but-not-quot-quot-td4723146.html}. Retrieved thanks to the Internet Archive: Wayback Machine.
}
\usage{
frac_to_numeric(n)
}
\arguments{
\item{n}{character vector that contains the fraction or mixed number (can
also include text, ex. inch, inches, etc. that will be removed from
the vector)}
}
\value{
the numeric \code{\link[base]{vector}} as a decimal
}
\description{
Converts a fraction or a mixed number to a decimal
}
\note{
If you have a measurement in feet + inches, then use \code{\link{construction_fraction}}
instead.
}
\examples{

# Please refer to the iemisc: Construction Measurement Examples vignette for
# additional examples
 
# Example 1 -- Reference 1

library(iemisc)

xx <- as.character(fractional::fractional(1:9 / 12))

try(frac_to_numeric(xx))
# Please note that there will be an error because this function is designed to
# only process one fraction at a time.

lapply(xx, frac_to_numeric)
# Please note that this is the correct way to work with several fractions at once.




# Example 2

library(iemisc)

xi <- fracture::fracture((50:65) / 12)

try(frac_to_numeric(xi))
# Please note that there will be an error because this function is designed to
# only process one fraction at a time.

lapply(xi, frac_to_numeric)
# Please note that this is the correct way to work with several fractions at once.




# Example 3

library(iemisc)

xyy <- fracture::fracture((1:11) / 12)

try(frac_to_numeric(xyy))
# Please note that there will be an error because this function is designed to
# only process one fraction at a time.

lapply(xyy, frac_to_numeric)
# Please note that this is the correct way to work with several fractions at once.



 
# Example 4

library(iemisc)

xft <- as.character(MASS::fractions((1:70) / 12))

try(frac_to_numeric(xft))
# Please note that there will be an error because this function is designed to
# only process one fraction at a time.

lapply(xft, frac_to_numeric)
# Please note that this is the correct way to work with several fractions at once.



 
# Example 5

library(iemisc)

pix <- "270/11"

pi1 <- "22/7" # Reference 3

pi2 <- "355/113" # Reference 3

frac_to_numeric(pix)

frac_to_numeric(pi1)

frac_to_numeric(pi2)



 
# Example 6

# If you have a construction measurement that includes a dimension in feet,
# such as 49 ft 7 5/8 in, don't use the frac_to_numeric function, instead
# use the construction_fraction function.

library(iemisc)

xxift <- "49 ft 7 5/8 in"

construction_decimal(xxift, result = "traditional", output = "vector")




# Example 7 -- Reference 2

truss_marks <- "19 3/16 inches"

frac_to_numeric(truss_marks)




}
\references{
\enumerate{
   \item Bill Venables, 2016-02-10, "Vulgar Fractions in R", fractional vignette, \url{https://CRAN.R-project.org/package=fractional/vignettes/Vulgar_Fractions_in_R.html}.
   \item The Home Depot, 9 December 2022, "How to Read a Tape Measure", \url{https://www.homedepot.com/c/ab/how-to-read-a-tape-measure/9ba683603be9fa5395fab90e6f14546}.
   \item Wikimedia Foundation, Inc. Wikipedia, 29 December 2021, "Pi", \url{https://en.wikipedia.org/wiki/Pi}.
}
}
\author{
Irucka Embry
}
